import java.io.*;
import java.util.*;
import java.math.*;

public class C implements Runnable {
	private static BufferedReader in;
	private static StringTokenizer st;
	private static PrintWriter out;

	// 10
	
	class Edge {
		int to, flow, capacity;
		Edge reverse;

		Edge(int to, int capacity) {
			this.to = to;
			this.flow = 0;
			this.capacity = capacity;
			this.reverse = null;
		}
	}

	private Edge addEdge(List<Edge>[] graph, int from, int to, int capacity) {
		Edge normal = new Edge(to, capacity);
		Edge reverse = new Edge(from, 0);
		normal.reverse = reverse;
		reverse.reverse = normal;
		graph[from].add(normal);
		graph[to].add(reverse);
		return normal;
	}

	class Action {
		int shipId, to;

		public Action(int shipId, int to) {
			this.shipId = shipId;
			this.to = to;
		}
	}

	private void solve() throws IOException {
		int n = nextInt(), m = nextInt(), k = nextInt();
		int from = nextInt() - 1, to = nextInt() - 1;
		List<Edge>[] flowGraph = new List[n + 2];
		for (int i = 0; i < n + 2; i++) {
			flowGraph[i] = new ArrayList<>();
		}
		Edge[] allEdges = new Edge[2 * m];
		for (int i = 0; i < m; i++) {
			int u = nextInt() - 1, v = nextInt() - 1;
			allEdges[2 * i] = addEdge(flowGraph, u, v, 1);
			allEdges[2 * i + 1] = addEdge(flowGraph, v, u, 1);
		}

		int s = n, t = n + 1;
		final int maxResult = 100000;
		addEdge(flowGraph, s, from, maxResult);
		addEdge(flowGraph, to, t, maxResult);
		int flowValue = maxFlow(n + 2, s, t, flowGraph, allEdges);
		
		List<List<Integer>> pathes = getPathes(n + 2, s, t, flowGraph);
		if (flowValue != pathes.size())
			throw new AssertionError();
		boolean[][] was = new boolean[n][n];
		for (List<Integer> path : pathes) {
			if (path.size() == 1)
				throw new AssertionError();
			for (int i = 0; i < path.size() - 1; i++) {
				int u = path.get(i), v = path.get(i + 1);
				if (was[u][v] || was[v][u])
					throw new AssertionError();
				was[u][v] = was[v][u] = true;
			}
		}
		int pathesCount = pathes.size();
		int[] lastStart = new int[pathesCount];
		List<Action>[] actions = new List[maxResult];
		for (int i = 0; i < maxResult; i++)
			actions[i] = new ArrayList<>();
		int result = 0;
		for (int i = 0; i < k; i++) {
			int bestPath = -1;
			int bestTime = Integer.MAX_VALUE;
			for (int j = 0; j < pathesCount; j++) {
				int currentTime = lastStart[j] + pathes.get(j).size() - 1;
				if (currentTime < bestTime) {
					bestTime = currentTime;
					bestPath = j;
				}
			}

			result = Math.max(result, bestTime);

			for (int j = 1; j < pathes.get(bestPath).size(); j++) {
				int currentTime = lastStart[bestPath] + j - 1;
				int currentVertex = pathes.get(bestPath).get(j);
				actions[currentTime].add(new Action(i + 1, currentVertex + 1));
			}

			++lastStart[bestPath];
		}

		out.println(result);

		for (int i = 0; i < result; i++) {
			out.print(actions[i].size());
			for (Action a : actions[i]) {
				out.print(" " + a.shipId + " " + a.to);
			}
			out.println();
		}
	}

	private List<List<Integer>> getPathes(int n, int s, int t,
			List<Edge>[] graph) {
		boolean[] used = new boolean[n];
		Queue<Integer> q = new ArrayDeque<>();
		int[] cameFrom = new int[n];
		Edge[] edgeUsed = new Edge[n];
		List<List<Integer>> pathes = new ArrayList<List<Integer>>();
		while (true) {
			Arrays.fill(used, false);
			used[s] = true;
			q.add(s);
			for (int i = 0; i < n; i++)
				Collections.shuffle(graph[i]);
			while (!q.isEmpty()) {
				int u = q.poll();
				for (Edge e : graph[u]) {
					if (!used[e.to] && e.flow > 0) {
						used[e.to] = true;
						cameFrom[e.to] = u;
						edgeUsed[e.to] = e;
						q.add(e.to);
					}
				}
			}
			if (!used[t])
				break;
			int cursor = t;
			List<Integer> path = new ArrayList<Integer>();
			while (cursor != s) {
				if (cursor != t)
					path.add(cursor);
				Edge e = edgeUsed[cursor];
				e.flow -= 1;
				e.reverse.flow += 1;
				cursor = cameFrom[cursor];
			}
			Collections.reverse(path);
			pathes.add(path);
		}
		return pathes;
	}

	private int maxFlow(int n, int s, int t, List<Edge>[] graph, Edge[] allEdges) {
		boolean[] used = new boolean[n];
		Queue<Integer> q = new ArrayDeque<>();
		int[] cameFrom = new int[n];
		Edge[] edgeUsed = new Edge[n];
		int result = 0;
		while (true) {
			Arrays.fill(used, false);
			used[s] = true;
			q.add(s);
			for (int i = 0; i < n; i++)
				Collections.shuffle(graph[i]);
			while (!q.isEmpty()) {
				int u = q.poll();
				for (Edge e : graph[u]) {
					if (!used[e.to] && e.capacity > e.flow) {
						used[e.to] = true;
						cameFrom[e.to] = u;
						edgeUsed[e.to] = e;
						q.add(e.to);
					}
				}
			}
			if (!used[t])
				break;
			++result;
			int cursor = t;
			while (cursor != s) {
				Edge e = edgeUsed[cursor];
				e.flow += 1;
				e.reverse.flow -= 1;
				cursor = cameFrom[cursor];
			}
			for (int i = 0; i < allEdges.length; i += 2) {
				Edge first = allEdges[i];
				Edge second = allEdges[i + 1];
				if (first.flow > 0 && second.flow > 0) {
					--first.flow;
					--second.flow;
					++first.reverse.flow;
					++second.reverse.flow;
				}
			}
		}
		return result;
	}

	public void run() {
		final String className = this.getClass().getName().toLowerCase();

		try {
			try {
				in = new BufferedReader(new FileReader(className + ".in"));
				out = new PrintWriter(new FileWriter(className + ".out"));
			} catch (FileNotFoundException e) {
				in = new BufferedReader(new InputStreamReader(System.in));
				out = new PrintWriter(System.out);
			}

			solve();

			out.close();
		} catch (IOException e) {
			e.printStackTrace();
			System.exit(1);
		}
	}

	public static void main(String[] args) {
		new C().run();
		// new Thread(null, new Template(), "Template", (1L << 24)).start();
	}

	private String nextToken() throws IOException {
		while (st == null || !st.hasMoreTokens()) {
			String line = in.readLine();
			if (line == null) {
				return null;
			}
			st = new StringTokenizer(line);
		}
		return st.nextToken();
	}

	private int nextInt() throws IOException {
		return Integer.parseInt(nextToken());
	}

	private long nextLong() throws IOException {
		return Long.parseLong(nextToken());
	}

	private double nextDouble() throws IOException {
		return Double.parseDouble(nextToken());
	}

}
